<?php
// dumped the utility functions into its own separate file
// I am trying to keep the plugin foorprint down as low as possible
// rename each function with an _l and then call after a load

if ( !defined( 'ABSPATH' ) ) {
	status_header( 404 );
	exit;
}

function ss_append_file( $filename, &$content ) {
	// this writes content to a file in the uploads directory in the 'stop-spammer-registrations' directory
	// changed to write to the current directory - content_dir is a bad place
	$file = SS_PLUGIN_DATA . $filename;
	// initialize the WordPress filesystem
	global $wp_filesystem;
	if ( empty( $wp_filesystem ) ) {
		require_once ABSPATH . 'wp-admin/includes/file.php';
		WP_Filesystem();
	}
	// check if the file exists and append content
	if ( $wp_filesystem->exists( $file ) ) {
		$current_content = $wp_filesystem->get_contents( $file );
		$content = $current_content . $content; // Append new content
	}
	// write the content to the file
	if ( $wp_filesystem->put_contents( $file, $content, FS_CHMOD_FILE ) === false ) {
		return false; // failed to write to the file
	}
	return true;
}

function ss_read_file( $f, $method = 'GET' ) {
	// try this using Wp_Http
	if ( !class_exists( 'WP_Http' ) ) {
		include_once( ABSPATH . WPINC . '/class-http.php' );
	}
	$request		  = new WP_Http;
	$parms			  = array();
	$parms['timeout'] = 10; // bump timeout a little we are timing out in Google
	$parms['method']  = $method;
	$result		      = $request->request( $f, $parms );
	// see if there is anything there
	if ( empty( $result ) ) {
		return '';
	}
	if ( is_array( $result ) ) {
		$ansa = $result['body'];
		return $ansa;
	}
	if ( is_object( $result ) ) {
		$ansa = 'ERR: ' . $result->get_error_message();
		return $ansa; // return $ansa when debugging
		// return '';
	}
	return '';
}

function ss_read_filex( $filename ) {
	// read file
	$file = SS_PLUGIN_DATA . $filename;
	if ( file_exists( $file ) ) {
		return file_get_contents( $file );
	}
	return 'File Not Found';
}

function ss_file_exists( $filename ) {
	$file = SS_PLUGIN_DATA . $filename;
	if ( !file_exists( $file ) ) {
		return false;
	}
	return filesize( $file );
}

function ss_file_delete( $filename ) {
	$file = SS_PLUGIN_DATA . $filename;
	return @unlink( $file );
}

// debug functions
// change the debug = false to debug = true to start debugging
// the plugin will drop a file debug.txt in the current directory (root, wp-admin, or network)
// directory must be writeable or plugin will crash
function sfs_errorsonoff( $old = null ) {
	$debug = false; // change to true to debug, false to stop all debugging
	if ( !$debug ) {
		return;
	}
	if ( empty( $old ) ) {
		// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_set_error_handler -- Debug function disabled by default, only used when explicitly enabled for diagnostics
		return set_error_handler( "sfs_ErrorHandler" );
	}
	restore_error_handler();
}

function sfs_debug_msg( $msg ) {
	// used to aid debugging - adds to debug file
	$debug = false;
	$ip	   = ss_get_ip();
	if ( !$debug ) {
		return;
	}
	$now = gmdate( 'Y/m/d H:i:s', time() + ( get_option( 'gmt_offset' ) * 3600 ) );
	// get the program that is running
	$sname = isset( $_SERVER['REQUEST_URI'] ) && !empty( $_SERVER['REQUEST_URI'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : ( isset( $_SERVER['SCRIPT_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SCRIPT_NAME'] ) ) : '' );
	@file_put_contents( SS_PLUGIN_DATA . "debug.txt", "$now: $sname, $msg, $ip \r\n", FILE_APPEND );
}

function sfs_ErrorHandler( $errno, $errmsg, $filename, $linenum ) {
	// write the answers to the file
	// we are only concerned with the errors and warnings, not the notices
	// if ( $errno == E_NOTICE || $errno == E_WARNING ) return false;
	// if ( $errno == 2048 ) return; // WordPress throws deprecated all over the place
	$serrno = "";
	if ( ( strpos( $filename, 'ss' ) === false ) && ( strpos( $filename, 'admin-options' ) === false ) && ( strpos( $filename, 'mu-options' ) === false ) && ( strpos( $filename, 'stop-spam' ) === false ) && ( strpos( $filename, 'sfr_mu' ) === false ) && ( strpos( $filename, 'settings.php' ) === false ) && ( strpos( $filename, 'options-general.php' ) === false ) ) {
		return false;
	}
	switch ( $errno ) {
		case E_ERROR:
			$serrno = 'Fatal run-time errors. These indicate errors that can not be recovered from, such as a memory allocation problem. Execution of the script is halted. ';
			break;
		case E_WARNING:
			$serrno = 'Run-time warnings (non-fatal errors). Execution of the script is not halted. ';
			break;
		case E_NOTICE:
			$serrno = 'Run-time notices. Indicate that the script encountered something that could indicate an error, but could also happen in the normal course of running a script. ';
			break;
		default;
			$serrno = 'Unknown Error Type ' . $errno . '';
	}
	if ( strpos( $errmsg, 'modify header information' ) ) {
		return false;
	}
	$now = gmdate( 'Y/m/d H:i:s', time() + ( get_option( 'gmt_offset' ) * 3600 ) );
	$m1  = memory_get_usage( true );
	$m2  = memory_get_peak_usage( true );
	$ip  = ss_get_ip();
	$msg = '
		Time: ' . $now . '
		Error Number: ' . $errno . '
		Error Type: ' . $serrno . '
		Error Msg: ' . $errmsg . '
		IP Address: ' . $ip . '
		File Name: ' . $filename . '
		Line Number: ' . $linenum . '
		Memory Used: ' . $m1 . ' Peak: ' . $m2 . '
		---------------------
	';
	$msg = str_replace( "\t", '', $msg );
	// write out the error
	@file_put_contents( SS_PLUGIN_DATA . 'debug.txt', $msg, FILE_APPEND );
	return false;
}

// migrate wlist_email to wlist on plugin activation or update
function ss_migrate_wlist_email() {
	$options = get_option( 'ss_stop_sp_reg_options' );
	if ( !$options || !is_array( $options ) ) {
		return;
	}
	if ( !isset( $options['wlist_email'] ) || !is_array( $options['wlist_email'] ) || empty( $options['wlist_email'] ) ) {
		return;
	}
	$wlist = isset( $options['wlist'] ) && is_array( $options['wlist'] ) ? $options['wlist'] : array();
	foreach ( $options['wlist_email'] as $email ) {
		if ( !in_array( $email, $wlist, true ) ) {
			$wlist[] = $email;
		}
	}
	$options['wlist'] = $wlist;
	$options['wlist_email'] = array();
	update_option( 'ss_stop_sp_reg_options', $options );
}
add_action( 'admin_init', 'ss_migrate_wlist_email' );

?>