<?php
function adsw_autoload( $className ) {
    $className = ltrim( $className, '\\' );
    $fileName  = '';

    if ( $lastNsPos = strrpos( $className, '\\' ) ) {

        $namespace = substr( $className, 0, $lastNsPos );
        $className = substr( $className, $lastNsPos + 1 );

        $fileName = str_replace( '\\', DIRECTORY_SEPARATOR, $namespace ) . DIRECTORY_SEPARATOR;
    }

    $fileName .= $className . '.php';

    $file = ADSW_PATH . 'includes/' . $fileName;

    if ( file_exists( $file ) ) {
        require( $file );
    }
}
spl_autoload_register( 'adsw_autoload' );